﻿#ifndef ZPL_SDK_API_H
#define ZPL_SDK_API_H

#ifdef LINUX

#define SDK_API __attribute__ ((visibility("default")))
#define CALL_STACK
#define TTCHAR char
#else

#include <tchar.h>
#ifdef EXPORT_CDECL
#define CALL_STACK __cdecl
#else
#define CALL_STACK __stdcall
#endif

#ifdef __cplusplus
#define SDK_API extern "C" //__declspec(dllexport)
#else
#define SDK_API //__declspec(dllexport)
#endif

#endif

#if defined __MINGW32__
#pragma message("__MINGW32__")
#ifdef __cplusplus
#define SDK_API extern "C" __declspec(dllexport)
#pragma message("__cplusplus")
#else
#define SDK_API __declspec(dllexport)
#endif
#endif

#define TTCHAR char

SDK_API int CALL_STACK ZPL_StartFormat(void* handle);

SDK_API int CALL_STACK ZPL_EndFormat(void* handle);

SDK_API int CALL_STACK ZPL_ScalableFontText(void* handle, int xPos, int yPos, char fontName, int orientation, int fontWidth, int fontHeight, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_SetUserFontName(void* handle, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_Text(void* handle, int xPos, int yPos, int fontNum, int orientation, int fontWidth, int fontHeight, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_Text_Block(void* handle, int xPos, int yPos, int fontNum, int orientation, int fontWidth, int fontHeight, int textblockWidth, int textblockHeight, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_FieldHexadecimalIndicator(void* handle);

SDK_API int CALL_STACK ZPL_AztecBarcode(void* handle, int xPos, int yPos, int orientation, int dpi, char extChannel, int eccLevel, char menuSymbol, int symbols, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_BarCode11(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_BarCode25(void* handle, char type, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_BarCode39(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_BarCode49(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char mode, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_PlanetCode(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_Pdf417(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, int securityLevel, int columns, int rows, char truncate, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_CodeEan8(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_UpceCode(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_BarCode93(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_BarCode128(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char checkDigit, char mode, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_CodeEan13(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_MicroPdf417(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, int mode, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_AnsiCodebar(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char startChar, char stopChar, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_LogMarsBarcode(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char lineAboveCode, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_MsiBarcode(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAbovecode, char checkDigit, char insertCheck, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_PlesseyBarcode(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char checkDigit, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_QRCode(void* handle, int xPos, int yPos, int orientation, int model, int dpi, char eccLevel, char input, char charMode, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_UpcExtensions(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_UpcaBarcode(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_DataMatrixBarcode(void* handle, int xPos, int yPos, int orientation, int codeHeight, int level, int columns, int rows, int formatId, int aspectRatio, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_SetChangeFontEncoding(void* handle, int encodeType);

SDK_API int CALL_STACK ZPL_SetVietMode(void* handle, int vietmode);

SDK_API int CALL_STACK ZPL_SetVietFontEncoding(void* handle);

SDK_API int CALL_STACK ZPL_SetChangeCaret(void* handle, char charactor);

SDK_API int CALL_STACK ZPL_PostalBarcode(void* handle, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, int postalType, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_SetChangeDelimiter(void* handle, char charactor);

SDK_API int CALL_STACK ZPL_SetChangeDefaultFont(void* handle, char fontName, int width, int height);

SDK_API int CALL_STACK ZPL_SetChangeTilde(void* handle, char charactor);

SDK_API int CALL_STACK ZPL_GraphicBox(void* handle, int xPos, int yPos, int width, int height, int thickness, int rounding);

SDK_API int CALL_STACK ZPL_GraphicCircle(void* handle, int xPos, int yPos, int diameter, int thickness);

SDK_API int CALL_STACK ZPL_GraphicDiagonalLine(void* handle, int xPos, int yPos, int orientation, int width, int height, int thickness);

SDK_API int CALL_STACK ZPL_GraphicEllipse(void* handle, int xPos, int yPos, int width, int height, int thickness);

SDK_API int CALL_STACK ZPL_PrintImage(void* handle, int xPos, int yPos, const TTCHAR* imgName);

//add by wjz 20210923
SDK_API int CALL_STACK ZPL_PrintImageStream(void* handle, int xPos, int yPos, char* data, int len);

SDK_API int CALL_STACK ZPL_GraphicSymbol(void* handle, int xPos, int yPos, int orientation, int width, int height, const TTCHAR* symbol);

SDK_API int CALL_STACK ZPL_HostStatusReturn(void* handle, char* statuString);

SDK_API int CALL_STACK ZPL_SetMediaSensorCalibration(void* handle);

SDK_API int CALL_STACK ZPL_SetDiagnosticsMode(void* handle, int isEnable);

SDK_API int CALL_STACK ZPL_SetPowerOnReset(void* handle);

SDK_API int CALL_STACK ZPL_SetLabelHome(void* handle, int xPos, int yPos);

SDK_API int CALL_STACK ZPL_SetLabelLength(void* handle, int length);

SDK_API int CALL_STACK ZPL_SetLabelReversePrint(void* handle, char enable);

SDK_API int CALL_STACK ZPL_SetLabelShift(void* handle, int shift);

SDK_API int CALL_STACK ZPL_SetLabelTop(void* handle, int top);

SDK_API int CALL_STACK ZPL_SetPrintMode(void* handle, char mode, char prePeelSelect);

SDK_API int CALL_STACK ZPL_SetMediaTracking(void* handle, char mediaType, int offset);

SDK_API int CALL_STACK ZPL_SetMediaType(void* handle, char type);

SDK_API int CALL_STACK ZPL_SlewToHomePosition(void* handle, int type);

SDK_API int CALL_STACK ZPL_SetPrintingMirrorImage(void* handle, char enable);

SDK_API int CALL_STACK ZPL_SetPrintOrientation(void* handle, int orientation);

SDK_API int CALL_STACK ZPL_SetPrintQuantity(void* handle, int totalQuantity, int pauseAndCutValue, int replicatesOfEachSerialNumber, char overridePauseCount);

SDK_API int CALL_STACK ZPL_SetPrintRate(void* handle, int printSpeed, int slewSpeed, int backfeedSpeed);

SDK_API int CALL_STACK ZPL_SetPrintWidth(void* handle, int width);

SDK_API int CALL_STACK ZPL_SetSerialCommunications(void* handle, int baudRate, int wordLength, char parity, int stopBits, char protocolMode);

SDK_API int CALL_STACK ZPL_SetPrintDarkness(void* handle, int darkness);

SDK_API int CALL_STACK ZPL_SetSerializationField(void* handle, int xPos, int yPos, const TTCHAR* mask, const TTCHAR* increment, const TTCHAR* text);

SDK_API int CALL_STACK ZPL_SetTearOffAdjustPosition(void* handle, int position);

SDK_API int CALL_STACK ZPL_PrintConfigurationLabel(void* handle);

SDK_API int CALL_STACK ZPL_GetPrinterIpAddress(void* handle, char* ipAddress);

SDK_API int CALL_STACK ZPL_GetPrinterStatus(void* handle, int* Status);

SDK_API int CALL_STACK ZPL_GetPrinterOdometer(void* handle, char* meters);

SDK_API int CALL_STACK ZPL_GetLabelLength(void* handle, char* length);

SDK_API int CALL_STACK ZPL_GetLabelWidth(void* handle, char* width);

SDK_API int CALL_STACK ZPL_GetPrinterSeriesNumber(void* handle, char* sn);

SDK_API int CALL_STACK ZPL_GetPrinterMacAddress(void* handle, char* macAddress);

SDK_API int CALL_STACK ZPL_GetPrinterName(void* handle, char* name);

SDK_API int CALL_STACK ZPL_GetPrinterFirmwareVersion(void* handle, char* version);

SDK_API int CALL_STACK ZPL_GetPrinterDpi(void* handle, char* dpi);

SDK_API int CALL_STACK ZPL_LearnLabel(void* handle);

SDK_API int CALL_STACK ZPL_SetReprintAfterError(void* handle, char* pEnable);

SDK_API int CALL_STACK ZPL_SetPrintIpAddress(void* handle, const TTCHAR* ipaddress);

SDK_API int CALL_STACK ZPL_SetPrintSubnetMask(void* handle, const TTCHAR* mask);

SDK_API int CALL_STACK ZPL_SetPrintDefaultGateway(void* handle, const TTCHAR* gateway);

SDK_API int CALL_STACK ZPL_SetNetworkSetting(void* handle, char* network);

//SDK_API int CALL_STACK ZPL_PrintDirectoryLabel( void* handle, char* device, char* name, char* type );

SDK_API int CALL_STACK ZPL_SetWriteQuery(void* handle, int type);

SDK_API int CALL_STACK ZPL_RfidWrite(void* handle, char format, int begin, int size, char memoryBlock, const char* text);

SDK_API int CALL_STACK ZPL_RfidRead(void* handle, char format, int begin, int size, char memoryBlock, const char* headText, const char* tailText);

SDK_API int CALL_STACK ZPL_RfidCalibration(void* handle);

//add by wjz 20210527 设置反色
SDK_API int CALL_STACK ZPL_SetInverse(void* handle);

SDK_API int CALL_STACK ZPL_Text_BlockEx(void* handle, int xPos, int yPos, int fontNum, int orientation,
	int fontWidth, int fontHeight,
	int textblockWidth, int maxline, int align, int hline_spacing, int vline_spacing,
	const TTCHAR* text);


#endif
